<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Item extends MY_Controller {
	function __construct(){
        parent::__construct();
        $this->load->helper('form');
        $this->load->helper('url');
		$this->load->model('item_model');
		$this->load->model('setting_model');
		$this->load->model('user_model');
        $this->load->library('form_validation');
		
		// Check Session Login
		if(!isset($_SESSION['logged_in'])){
			redirect(site_url('auth/login'));
		}
	}
	
	public function index(){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		if(isset($_GET['search'])){
			$filter = array();
            if(!empty($_GET['value']) && $_GET['value'] != ''){
                $filter['item.value ='] = $_GET['value'];
			}

			$total_row = $this->item_model->count_total_filter($filter);
			$data['items'] = $this->item_model->get_filter($filter,url_param());
		}else{
			$total_row = $this->item_model->count_total();
			$data['items'] = $this->item_model->get_all(url_param());
		}
		$data['paggination'] = get_paggination($total_row,get_search());

		$this->load->view('item/index',$data);
	}
	
	public function create(){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		$data['item'] = $this->item_model->get_last_id();
		$this->load->view('item/form',$data);
	}

	public function edit($id = ''){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		$check_id = $this->item_model->get_by_id($id);
		if($check_id){
			$data['item'] = $check_id[0];
			$this->load->view('item/form',$data);
		}else{
			redirect(site_url('item'));
		}
	}

	public function save($id = ''){
        $value = $this->input->post('value');
        $image = $this->input->post('image');
        $id_order = $this->input->post('id_order');
        $data = array (
            'value' => $value,
            'image'=>$image
        );
        $config['upload_path'] = './upload/';
        $config['allowed_types'] = 'gif|jpg|jpeg|png';
        $config['max_size'] = 500;
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);
        if (empty($id)){
            if (!$this->upload->do_upload('image')) 
            {
            $error = array('error' => $this->upload->display_errors());
			$this->session->set_flashdata('upload_failed', $error['error']);
            redirect(site_url('item/create'));
            } else {
            unset($data['value']);
            $data = array('value' => $value,'image' => $this->upload->data('file_name'), 'id_order' => $id_order);
            $this->item_model->insert($data);
            $this->session->set_flashdata('upload_success', 'Data Updated. The file has been uploaded!');
            redirect(site_url('item'));
            }
        }else{
            if (!$this->upload->do_upload('image')) 
            {			
            $update_is = array('value' => $value, 'id_order' => $id_order);
            $this->item_model->update($id,$update_is);
            $error = array('error' => $this->upload->display_errors());
			$this->session->set_flashdata('upload_failed', $error['error']);
            redirect(site_url('item'));
            } else {
            $check_id = $this->item_model->get_by_id($id);
            unset($data['value']);
            $data_update = array('value' => $value,'image' => $this->upload->data('file_name'), 'id_order' => $id_order);
            $this->session->set_flashdata('upload_success', 'Data Updated. The file has been uploaded!');
            $path_to_file = './upload/'.$check_id[0]['image'];
            unlink($path_to_file);
            $this->item_model->update($id,$data_update);
            redirect(site_url('item'));
            }
        }
        redirect(site_url('item'));

	}

	public function delete($id){
		$check_id = $this->item_model->get_by_id($id);
        $path = "./upload/";
		if($check_id){
            $path_to_file = './upload/'.$check_id[0]['image'];
            unlink($path_to_file);
			$this->item_model->delete($id);
		}
		redirect(site_url('item'));
	}
	public function export_csv(){
		$filter = false;
		if(isset($_GET['search'])) {
			$filter = array();
			if (!empty($_GET['value']) && $_GET['value'] != '') {
				$filter[$_GET['search_by'] . ' LIKE'] = "%" . $_GET['value'] . "%";
			}
		}
		$data = $this->item_model->get_all_array($filter);
		$this->csv_library->export('item.csv',$data);
	}
}
