<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Register extends MY_Controller {
	function __construct(){
        parent::__construct();
		$this->load->model('register_model');
		$this->load->model('item_model');
		$this->load->model('setting_model');
		$this->load->model('user_model');
        $this->load->library('form_validation');
		
		// Check Session Login
		if(!isset($_SESSION['logged_in'])){
			redirect(site_url('auth/login'));
		}
	}
	
	public function index(){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		if(isset($_GET['search'])){
			$filter = array();
            if(!empty($_GET['voucher']) && $_GET['voucher'] != ''){
                $filter['register.voucher ='] = $_GET['voucher'];
			}

			$total_row = $this->register_model->count_total_filter($filter);
			$data['registers'] = $this->register_model->get_filter($filter,url_param());
		}else{
			$total_row = $this->register_model->count_total();
			$data['registers'] = $this->register_model->get_all(url_param());
		}
		$data['paggination'] = get_paggination($total_row,get_search());

		$this->load->view('register/index',$data);
	}
	
	public function create(){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		$data['item'] = $this->item_model->get_all();
		$this->load->view('register/form',$data);
	}

	public function edit($id = ''){
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		$check_id = $this->register_model->get_by_id($id);
		if($check_id){
			$data['register'] = $check_id[0];
			$data['item'] = $this->item_model->get_all();
			$this->load->view('register/form',$data);
		}else{
			redirect(site_url('register'));
		}
	}

	public function save($id = ''){
		$this->form_validation->set_rules('voucher', 'ID', 'required');
        
		$data['username'] = escape($this->input->post('username'));
		$data['voucher'] = escape($this->input->post('voucher'));
		$data['item_name'] = escape($this->input->post('item_name'));
		$data['id_image'] = escape($this->input->post('id_image'));
		$idm = $data['id_image'];
		$item = $this->item_model->get_by_id($idm);
		$data['item_value'] = $item[0]['value'];
		$data['used'] = escape($this->input->post('used'));
		$tgl = escape($this->input->post('date'));
        $date_input = explode(" - ", $tgl);
        $data['date_first'] = $date_input[0];
        $data['date_last'] = $date_input[1];
		$data['created_by'] = $_SESSION['username'];

		if ($this->form_validation->run() != FALSE && !empty($id)) {
			// EDIT
			$check_id = $this->register_model->get_by_id($id);
			if($check_id){
				unset($data['id']);
				$this->register_model->update($id,$data);
			}
		}elseif($this->form_validation->run() != FALSE && empty($id)){
			// INSERT NEW
			$this->register_model->insert($data);
		}else{
			$this->session->set_flashdata('form_false', 'Harap periksa form anda.');
			redirect(site_url('register/create'));
		}
		redirect(site_url('register'));
	}
	public function delete($id){
		$check_id = $this->register_model->get_by_id($id);
		if($check_id){
			$this->register_model->delete($id);
		}
		redirect(site_url('register'));
	}
	public function export_csv(){
		$filter = false;
		if(isset($_GET['search'])) {
			$filter = array();
			if (!empty($_GET['value']) && $_GET['value'] != '') {
				$filter[$_GET['search_by'] . ' LIKE'] = "%" . $_GET['value'] . "%";
			}
		}
		$data = $this->register_model->get_all_array($filter);
		$this->csv_library->export('register.csv',$data);
	}
}
