<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Setting extends MY_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('setting_model');
		$this->load->library('form_validation');
		$this->load->helper(array('form', 'url'));
		$this->load->model('user_model');

		// Check Session Login
		if (!isset($_SESSION['logged_in'])) {
			redirect(site_url('auth/login'));
		}
	}

	public function index()
	{
		if (isset($_GET['search'])) {
			$filter = array();
			if (!empty($_GET['value']) && $_GET['value'] != '') {
				$filter[$_GET['search_by'] . ' LIKE'] = "%" . $_GET['value'] . "%";
			}

			$total_row = $this->setting_model->count_total_filter($filter);
			$data['settings'] = $this->setting_model->get_filter($filter, url_param());
		} else {
			$total_row = $this->setting_model->count_total();
			$data['settings'] = $this->setting_model->get_all(url_param());
		}
		$data['paggination'] = get_paggination($total_row, get_search());

		$this->load->view('setting/index', $data);
	}

	public function create()
	{
		$code_setting = $this->setting_model->get_last_id();
		if ($code_setting) {
			$id = $code_setting[0]->id;
			$data['code_setting'] = generate_code('SUP', $id);
		} else {
			$data['code_setting'] = 'SUP001';
		}
		$this->load->view('setting/form', $data);
	}

	public function edit($id = '')
	{
		$check_id = $this->setting_model->get_by_id($id);
		$data['judul_app'] = $this->setting_model->get_by_id(1);
		if ($check_id) {
			$data['setting'] = $check_id[0];
			$this->load->view('setting/form', $data);
		} else {
			redirect(site_url('setting'));
		}
	}

	public function save($id = '')
	{
		$data['id'] = $this->input->post('id');
		$data['judul_app'] = $this->input->post('judul_app');
		$data['alamat'] = $this->input->post('alamat');
		$data['no_telp'] = $this->input->post('no_telp');
		$data['deskripsi_toko'] = $this->input->post('deskripsi_toko');
		$data['telegram'] = $this->input->post('telegram');
		$pw = $this->input->post('password');
		$username = $_SESSION['username'];
		if (!empty($pw)) {
			$this->session->set_flashdata('failed_favicon', 'Password Has Changed!');
			$datapw = array('password' => md5($pw));
			$this->user_model->update_pw($username, $datapw);
		}

		// Upload favicon file
		if (!empty($_FILES['favicon']['name'])) {
			$config['upload_path'] = './uploads/'; // set the upload path
			$config['allowed_types'] = 'png|jpg|gif'; // set the allowed file types
			// $config['max_size']     	= 5000; // 2MB
			// $config['max_width']			= 50;
			// $config['max_height']			= 50;
			$config['encrypt_name'] = TRUE;
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('favicon')) {
				$error = array('error' => $this->upload->display_errors());
				$this->session->set_flashdata('failed_favicon', $error['error']);
			} else {
				$upload_data = $this->upload->data(); //Returns array of containing all of the data related to the file you uploaded.
				$data['favicon'] = $upload_data['file_name'];
			}
		}
		// Upload background file
		if (!empty($_FILES['background']['name'])) {
			$config['upload_path'] = './uploads/'; // set the upload path
			$config['allowed_types'] = 'png|jpg|gif'; // set the allowed file types
			// $config['max_size']     	= 5000; // 2MB
			// $config['max_width']			= 1500;
			// $config['max_height']			= 800;
			$config['encrypt_name'] = TRUE;
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('background')) {
				$error = array('error' => $this->upload->display_errors());
				$this->session->set_flashdata('failed_background', $error['error']);
			} else {
				$upload_data = $this->upload->data(); //Returns array of containing all of the data related to the file you uploaded.
				$data['background'] = $upload_data['file_name'];
			}
		}

		// Upload background file
		if (!empty($_FILES['backgroundmobile']['name'])) {
			$config['upload_path'] = './uploads/'; // set the upload path
			$config['allowed_types'] = 'png|jpg|gif'; // set the allowed file types
			// $config['max_size']     	= 5000; // 2MB
			// $config['max_width']			= 1500;
			// $config['max_height']			= 800;
			$config['encrypt_name'] = TRUE;
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('backgroundmobile')) {
				$error = array('error' => $this->upload->display_errors());
				$this->session->set_flashdata('failed_background', $error['error']);
			} else {
				$upload_data = $this->upload->data(); //Returns array of containing all of the data related to the file you uploaded.
				$data['backgroundmobile'] = $upload_data['file_name'];
			}
		}

		// Upload logo file
		if (!empty($_FILES['logo']['name'])) {
			$config['upload_path'] = './uploads/'; // set the upload path
			$config['allowed_types'] = 'png|jpg|gif'; // set the allowed file types
			// $config['max_size']     	= 5000; // 2MB
			// $config['max_width']			= 1500;
			// $config['max_height']			= 1500;
			$config['encrypt_name'] = TRUE;
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('logo')) {
				$error = array('error' => $this->upload->display_errors());
				$this->session->set_flashdata('failed_logo', $error['error']);
			} else {
				$upload_data = $this->upload->data(); //Returns array of containing all of the data related to the file you uploaded.
				$data['logo'] = $upload_data['file_name'];
			}
		}

		// Upload spinner file
		if (!empty($_FILES['spinner']['name'])) {
			$config['upload_path'] = './uploads/'; // set the upload path
			$config['allowed_types'] = 'png|jpg|gif'; // set the allowed file types
			// $config['max_size']     	= 5000; // 2MB
			// $config['max_width']			= 1500;
			// $config['max_height']			= 1500;
			$config['encrypt_name'] = TRUE;
			$this->load->library('upload', $config);
			if (!$this->upload->do_upload('spinner')) {
				$error = array('error' => $this->upload->display_errors());
				$this->session->set_flashdata('failed_spinner', $error['error']);
			} else {
				$upload_data = $this->upload->data(); //Returns array of containing all of the data related to the file you uploaded.
				$data['spinner'] = $upload_data['file_name'];
			}
		}
		$check_id = $this->setting_model->get_by_id($id);
		if ($check_id) {
			unset($data['id']);
			if (!empty($data['favicon'])) {
				if (!empty($check_id[0]['favicon'])) {
					$pathfavicon = './uploads/' . $check_id[0]['favicon'];
					unlink($pathfavicon);
				}
			}
			if (!empty($data['background'])) {
				if (!empty($check_id[0]['background'])) {
					$pathbackground = './uploads/' . $check_id[0]['background'];
					unlink($pathbackground);
				}
			}
			if (!empty($data['backgroundmobile'])) {
				if (!empty($check_id[0]['backgroundmobile'])) {
					$pathbackgroundmobile = './uploads/' . $check_id[0]['backgroundmobile'];
					unlink($pathbackgroundmobile);
				}
			}
			if (!empty($data['spinner'])) {
				if (!empty($check_id[0]['spinner'])) {
					$pathspinner = './uploads/' . $check_id[0]['spinner'];
					unlink($pathspinner);
				}
			}
			if (!empty($data['logo'])) {
				if (!empty($check_id[0]['logo'])) {
					$pathlogo = './uploads/' . $check_id[0]['logo'];
					unlink($pathlogo);
				}
			}
			$this->setting_model->update($id, $data);
		}
		redirect(site_url('setting/edit/1'));
	}
	public function delete($id)
	{
		$check_id = $this->setting_model->get_by_id($id);
		if ($check_id) {
			$this->setting_model->delete($id);
		}
		redirect(site_url('setting'));
	}
	public function export_csv()
	{
		$filter = false;
		if (isset($_GET['search'])) {
			$filter = array();
			if (!empty($_GET['value']) && $_GET['value'] != '') {
				$filter[$_GET['search_by'] . ' LIKE'] = "%" . $_GET['value'] . "%";
			}
		}
		$data = $this->setting_model->get_all_array($filter);
		$this->csv_library->export('setting.csv', $data);
	}
}
