<?php $this->load->view('element/head');?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Item Index
        <small>List Item</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Item Index</a></li>
        <li class="active">Here</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
        <?php if($this->session->flashdata('upload_failed')){?>
		<div class="alert alert-warning alert-dismissible">
			<button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>
			<h4>
				<i class="icon fa fa-bell-o"></i>Notification
			</h4>
			<?php echo $this->session->flashdata('upload_failed');?> Image not updated.
		</div>
	  <?php } ?>
      <?php if($this->session->flashdata('upload_success')){?>
		<div class="alert alert-success alert-dismissible">
			<button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>
			<h4>
				<i class="icon fa fa-bell-o"></i>Notification
			</h4>
			<?php echo $this->session->flashdata('upload_success');?>
		</div>
	  <?php } ?>
            <ul class="nav nav-tabs">
                <li role="presentation"><a href="<?php echo site_url('item/create');?>">Input Item</a></li>
                <li role="presentation" class="active"><a href="<?php echo site_url('item');?>">List Item</a></li>
            </ul>
          <div class="box">
            <div class="box-header">
              <h3 class="box-title">Data Table Item</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
            <form action="<?php echo site_url('item?search=true');?>" method="GET">
                <input type="hidden" class="form-control" name="search" value="true"/>
                <div class="box-body pad">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="id">Value</label>
                      <input type="text" class="form-control" name="value" value="<?php echo !empty($_GET['value']) ? $_GET['value'] : '';?>"/>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label for="submit">&nbsp</label>
                      <input type="submit" value="Cari" class="form-control btn btn-primary">
                    </div>
                  </div>
                </div>
              </form>
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                  <th>Value</th>
                  <th>Image</th>
                  <th>Order</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
				<?php if(isset($items) && is_array($items)){ ?>
				  <?php foreach($items as $item){?>
                <tr>
                    <td><?php echo $item->value;?></td>
					<td><img src="<?php echo "upload/".$item->image;?>" class="image-responsive" style="height: 150px;"></td>
          <td><?php echo $item->id_order;?></td>
					<td>
						<a href="<?php echo site_url('item/edit').'/'.$item->id;?>" class="btn btn-xs btn-primary">Edit</a>
						<a onclick="return confirm('Are you sure you want to delete this item?');" href="<?php echo site_url('item/delete').'/'.$item->id;?>" class="btn btn-xs btn-danger">Delete</a>
					</td>
					</tr>
				  <?php } ?>
				<?php } ?>
                </tbody>
                <tfoot>
                </tfoot>
              </table>
            </div>
            <!-- /.box-body -->
            <div class="text-center">
              <?php echo $paggination;?>
            </div>
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
	  <!-- row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $this->load->view('element/footer');?>